/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import java.util.List;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BladeMaterialTooltips {
    public static final String BLADE_DATA = "BladeData";

    public static BladeMaterialTooltips getInstance() {
        return SingletonHolder.instance;
    }

    private BladeMaterialTooltips() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        if (stack.m_41782_() && stack.m_41783_().m_128441_(BLADE_DATA)) {
            CompoundTag bladeData = stack.m_41783_().m_128469_(BLADE_DATA);
            String translationKey = NBTHelper.getNBTCoupler(bladeData).getChild("tag").getChild("ShareTag").getRawCompound().m_128461_("translationKey");
            event.getToolTip().add(Component.m_237115_((String)translationKey));
        }
    }

    private static final class SingletonHolder {
        private static final BladeMaterialTooltips instance = new BladeMaterialTooltips();

        private SingletonHolder() {
        }
    }
}

